/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import net.optifine.IRandomEntity;
import net.optifine.RandomEntities;
import net.optifine.RandomEntity;
import net.optifine.config.ConnectedParser;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.config.VillagerProfession;
import net.optifine.reflect.Reflector;
import net.optifine.util.MathUtils;

public class RandomEntityRule {
    private String pathProps = null;
    private pc baseResLoc = null;
    private int index;
    private int[] textures = null;
    private pc[] resourceLocations = null;
    private int[] weights = null;
    private ayu[] biomes = null;
    private RangeListInt heights = null;
    private NbtTagValue nbtName = null;
    public int[] sumWeights = null;
    public int sumAllWeights = 1;
    private VillagerProfession[] professions = null;

    public RandomEntityRule(String pathProps, pc baseResLoc, int index, int[] textures, int[] weights, ayu[] biomes, RangeListInt heights, NbtTagValue nbtName, VillagerProfession[] professions) {
        this.pathProps = pathProps;
        this.baseResLoc = baseResLoc;
        this.index = index;
        this.textures = textures;
        this.weights = weights;
        this.biomes = biomes;
        this.heights = heights;
        this.nbtName = nbtName;
        this.professions = professions;
    }

    public boolean isValid(String path) {
        if (this.textures == null || this.textures.length == 0) {
            Config.warn("Invalid skins for rule: " + this.index);
            return false;
        }
        if (this.resourceLocations != null) {
            return true;
        }
        this.resourceLocations = new pc[this.textures.length];
        boolean optifine = this.pathProps.startsWith("optifine/mob/");
        pc locOf = RandomEntities.getLocationRandom(this.baseResLoc, optifine);
        if (locOf == null) {
            Config.warn("Invalid path: " + this.baseResLoc.a());
            return false;
        }
        for (int i2 = 0; i2 < this.resourceLocations.length; ++i2) {
            int index = this.textures[i2];
            if (index <= 1) {
                this.resourceLocations[i2] = this.baseResLoc;
                continue;
            }
            pc locNew = RandomEntities.getLocationIndexed(locOf, index);
            if (locNew == null) {
                Config.warn("Invalid path: " + this.baseResLoc.a());
                return false;
            }
            if (!Config.hasResource(locNew)) {
                Config.warn("Texture not found: " + locNew.a());
                return false;
            }
            this.resourceLocations[i2] = locNew;
        }
        if (this.weights != null) {
            if (this.weights.length > this.resourceLocations.length) {
                Config.warn("More weights defined than skins, trimming weights: " + path);
                int[] weights2 = new int[this.resourceLocations.length];
                System.arraycopy(this.weights, 0, weights2, 0, weights2.length);
                this.weights = weights2;
            }
            if (this.weights.length < this.resourceLocations.length) {
                Config.warn("Less weights defined than skins, expanding weights: " + path);
                int[] weights2 = new int[this.resourceLocations.length];
                System.arraycopy(this.weights, 0, weights2, 0, this.weights.length);
                int avgWeight = MathUtils.getAverage(this.weights);
                for (int i3 = this.weights.length; i3 < weights2.length; ++i3) {
                    weights2[i3] = avgWeight;
                }
                this.weights = weights2;
            }
            this.sumWeights = new int[this.weights.length];
            int sum = 0;
            for (int i4 = 0; i4 < this.weights.length; ++i4) {
                if (this.weights[i4] < 0) {
                    Config.warn("Invalid weight: " + this.weights[i4]);
                    return false;
                }
                this.sumWeights[i4] = sum += this.weights[i4];
            }
            this.sumAllWeights = sum;
            if (this.sumAllWeights <= 0) {
                Config.warn("Invalid sum of all weights: " + sum);
                this.sumAllWeights = 1;
            }
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            Config.warn("Invalid professions or careers: " + path);
            return false;
        }
        return true;
    }

    public boolean matches(IRandomEntity randomEntity) {
        RandomEntity rme;
        aer entity;
        String name;
        el pos;
        if (this.biomes != null && !Matches.biome(randomEntity.getSpawnBiome(), this.biomes)) {
            return false;
        }
        if (this.heights != null && (pos = randomEntity.getSpawnPosition()) != null && !this.heights.isInRange(pos.p())) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = randomEntity.getName())) {
            return false;
        }
        if (this.professions != null && randomEntity instanceof RandomEntity && (entity = (rme = (RandomEntity)randomEntity).getEntity()) instanceof aob) {
            aob entityVillager = (aob)entity;
            int profInt = entityVillager.dy();
            int careerInt = Reflector.getFieldValueInt(entityVillager, Reflector.EntityVillager_careerId, -1);
            if (profInt < 0 || careerInt < 0) {
                return false;
            }
            boolean matchProfession = false;
            for (int i2 = 0; i2 < this.professions.length; ++i2) {
                VillagerProfession prof = this.professions[i2];
                if (!prof.matches(profInt, careerInt)) continue;
                matchProfession = true;
                break;
            }
            if (!matchProfession) {
                return false;
            }
        }
        return true;
    }

    public pc getTextureLocation(pc loc, int randomId) {
        if (this.resourceLocations == null || this.resourceLocations.length == 0) {
            return loc;
        }
        int index = 0;
        if (this.weights == null) {
            index = randomId % this.resourceLocations.length;
        } else {
            int randWeight = randomId % this.sumAllWeights;
            for (int i2 = 0; i2 < this.sumWeights.length; ++i2) {
                if (this.sumWeights[i2] <= randWeight) continue;
                index = i2;
                break;
            }
        }
        return this.resourceLocations[index];
    }
}

