/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.ArrayList;
import java.util.Properties;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntityRule;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeInt;
import net.optifine.config.RangeListInt;

public class RandomEntityProperties {
    public String name = null;
    public String basePath = null;
    public qv[] resourceLocations = null;
    public RandomEntityRule[] rules = null;

    public RandomEntityProperties(String path, qv[] variants) {
        ConnectedParser cp = new ConnectedParser("RandomEntities");
        this.name = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.resourceLocations = variants;
    }

    public RandomEntityProperties(Properties props, String path, qv baseResLoc) {
        ConnectedParser cp = new ConnectedParser("RandomEntities");
        this.name = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.rules = this.parseRules(props, path, baseResLoc, cp);
    }

    public qv getTextureLocation(qv loc, IRandomEntity randomEntity) {
        if (this.rules != null) {
            for (int i = 0; i < this.rules.length; ++i) {
                RandomEntityRule rule = this.rules[i];
                if (!rule.matches(randomEntity)) continue;
                return rule.getTextureLocation(loc, randomEntity.getId());
            }
        }
        if (this.resourceLocations != null) {
            int randomId = randomEntity.getId();
            int index = randomId % this.resourceLocations.length;
            return this.resourceLocations[index];
        }
        return loc;
    }

    private RandomEntityRule[] parseRules(Properties props, String pathProps, qv baseResLoc, ConnectedParser cp) {
        ArrayList<RandomEntityRule> list = new ArrayList<RandomEntityRule>();
        int count = props.size();
        for (int i = 0; i < count; ++i) {
            bbg[] collarColors;
            MatchProfession[] professions;
            NbtTagValue nbtName;
            RandomEntityRule rule;
            int index = i + 1;
            String valTextures = props.getProperty("textures." + index);
            if (valTextures == null) {
                valTextures = props.getProperty("skins." + index);
            }
            if (valTextures == null) continue;
            int[] textures = cp.parseIntList(valTextures);
            int[] weights = cp.parseIntList(props.getProperty("weights." + index));
            bio[] biomes = cp.parseBiomes(props.getProperty("biomes." + index));
            RangeListInt heights = cp.parseRangeListInt(props.getProperty("heights." + index));
            if (heights == null) {
                heights = this.parseMinMaxHeight(props, index);
            }
            if (!(rule = new RandomEntityRule(pathProps, baseResLoc, index, textures, weights, biomes, heights, nbtName = cp.parseNbtTagValue("name", props.getProperty("name." + index)), professions = cp.parseProfessions(props.getProperty("professions." + index)), collarColors = cp.parseDyeColors(props.getProperty("collarColors." + index), "collar color", ConnectedParser.DYE_COLORS_INVALID))).isValid(pathProps)) continue;
            list.add(rule);
        }
        RandomEntityRule[] rules = list.toArray(new RandomEntityRule[list.size()]);
        return rules;
    }

    private RangeListInt parseMinMaxHeight(Properties props, int index) {
        String minHeightStr = props.getProperty("minHeight." + index);
        String maxHeightStr = props.getProperty("maxHeight." + index);
        if (minHeightStr == null && maxHeightStr == null) {
            return null;
        }
        int minHeight = 0;
        if (minHeightStr != null && (minHeight = Config.parseInt(minHeightStr, -1)) < 0) {
            Config.warn("Invalid minHeight: " + minHeightStr);
            return null;
        }
        int maxHeight = 256;
        if (maxHeightStr != null && (maxHeight = Config.parseInt(maxHeightStr, -1)) < 0) {
            Config.warn("Invalid maxHeight: " + maxHeightStr);
            return null;
        }
        if (maxHeight < 0) {
            Config.warn("Invalid minHeight, maxHeight: " + minHeightStr + ", " + maxHeightStr);
            return null;
        }
        RangeListInt list = new RangeListInt();
        list.addRange(new RangeInt(minHeight, maxHeight));
        return list;
    }

    public boolean isValid(String path) {
        int i;
        if (this.resourceLocations == null && this.rules == null) {
            Config.warn("No skins specified: " + path);
            return false;
        }
        if (this.rules != null) {
            for (i = 0; i < this.rules.length; ++i) {
                RandomEntityRule rule = this.rules[i];
                if (rule.isValid(path)) continue;
                return false;
            }
        }
        if (this.resourceLocations != null) {
            for (i = 0; i < this.resourceLocations.length; ++i) {
                qv loc = this.resourceLocations[i];
                if (Config.hasResource(loc)) continue;
                Config.warn("Texture not found: " + loc.a());
                return false;
            }
        }
        return true;
    }

    public boolean isDefault() {
        if (this.rules != null) {
            return false;
        }
        return this.resourceLocations == null;
    }
}

