/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.model.ITransformation;
import net.optifine.model.ModelUtils;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;
    private static final Random RANDOM = new Random(0L);

    public static dez makeModelCube(String spriteName, int tintIndex) {
        ddm sprite = Config.getMinecraft().K().a(spriteName);
        return BlockModelUtils.makeModelCube(sprite, tintIndex);
    }

    public static dez makeModelCube(ddm sprite, int tintIndex) {
        ArrayList generalQuads = new ArrayList();
        eq[] facings = eq.n;
        HashMap faceQuads = new HashMap();
        for (int i2 = 0; i2 < facings.length; ++i2) {
            eq facing = facings[i2];
            ArrayList<cux> quads = new ArrayList<cux>();
            quads.add(BlockModelUtils.makeBakedQuad(facing, sprite, tintIndex));
            faceQuads.put(facing, quads);
        }
        cvi itemOverrideList = cvi.a;
        dfg bakedModel = new dfg(generalQuads, faceQuads, true, true, sprite, cvk.a, itemOverrideList);
        return bakedModel;
    }

    public static dez joinModelsCube(dez modelBase, dez modelAdd) {
        ArrayList generalQuads = new ArrayList();
        generalQuads.addAll(modelBase.a(null, null, RANDOM));
        generalQuads.addAll(modelAdd.a(null, null, RANDOM));
        eq[] facings = eq.n;
        HashMap faceQuads = new HashMap();
        for (int i2 = 0; i2 < facings.length; ++i2) {
            eq facing = facings[i2];
            ArrayList quads = new ArrayList();
            quads.addAll(modelBase.a(null, facing, RANDOM));
            quads.addAll(modelAdd.a(null, facing, RANDOM));
            faceQuads.put(facing, quads);
        }
        boolean ao = modelBase.a();
        boolean builtIn = modelBase.c();
        ddm sprite = modelBase.d();
        cvk transforms = modelBase.e();
        cvi itemOverrideList = modelBase.f();
        dfg bakedModel = new dfg(generalQuads, faceQuads, ao, builtIn, sprite, transforms, itemOverrideList);
        return bakedModel;
    }

    public static cux makeBakedQuad(eq facing, ddm sprite, int tintIndex) {
        dhl posFrom = new dhl(0.0f, 0.0f, 0.0f);
        dhl posTo = new dhl(16.0f, 16.0f, 16.0f);
        cvb uv = new cvb(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        cuz face = new cuz(facing, tintIndex, "#" + facing.m(), uv);
        dfa modelRotation = dfa.a;
        cva partRotation = null;
        boolean uvLocked = false;
        boolean shade = true;
        cvf faceBakery = new cvf();
        cux quad = faceBakery.makeBakedQuad(posFrom, posTo, face, sprite, facing, (ITransformation)modelRotation, partRotation, uvLocked, shade);
        return quad;
    }

    public static dez makeModel(String modelName, String spriteOldName, String spriteNewName) {
        ddl textureMap = Config.getMinecraft().K();
        ddm spriteOld = textureMap.getSpriteSafe(spriteOldName);
        ddm spriteNew = textureMap.getSpriteSafe(spriteNewName);
        return BlockModelUtils.makeModel(modelName, spriteOld, spriteNew);
    }

    public static dez makeModel(String modelName, ddm spriteOld, ddm spriteNew) {
        if (spriteOld == null || spriteNew == null) {
            return null;
        }
        dfd modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        dfe mrl = new dfe(modelName, "");
        dez model = modelManager.a(mrl);
        if (model == null || model == modelManager.a()) {
            return null;
        }
        dez modelNew = ModelUtils.duplicateModel(model);
        eq[] faces = eq.n;
        for (int i2 = 0; i2 < faces.length; ++i2) {
            eq face = faces[i2];
            List quads = modelNew.a(null, face, RANDOM);
            BlockModelUtils.replaceTexture(quads, spriteOld, spriteNew);
        }
        List quadsGeneral = modelNew.a(null, null, RANDOM);
        BlockModelUtils.replaceTexture(quadsGeneral, spriteOld, spriteNew);
        return modelNew;
    }

    private static void replaceTexture(List<cux> quads, ddm spriteOld, ddm spriteNew) {
        ArrayList<cux> quadsNew = new ArrayList<cux>();
        for (cux quad : quads) {
            if (quad.a() == spriteOld) {
                quad = new cve(quad, spriteNew);
            }
            quadsNew.add(quad);
        }
        quads.clear();
        quads.addAll(quadsNew);
    }

    public static void snapVertexPosition(dhl pos) {
        pos.a(BlockModelUtils.snapVertexCoord(pos.a()), BlockModelUtils.snapVertexCoord(pos.b()), BlockModelUtils.snapVertexCoord(pos.c()));
    }

    private static float snapVertexCoord(float x) {
        if (x > -1.0E-6f && x < 1.0E-6f) {
            return 0.0f;
        }
        if (x > 0.999999f && x < 1.000001f) {
            return 1.0f;
        }
        return x;
    }

    public static cea getOffsetBoundingBox(cea aabb, bcs.b offsetType, el pos) {
        int x = pos.o();
        int z = pos.q();
        long k2 = (long)(x * 3129871) ^ (long)z * 116129781L;
        k2 = k2 * k2 * 42317861L + k2 * 11L;
        double dx = ((double)((float)(k2 >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dz = ((double)((float)(k2 >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dy = 0.0;
        if (offsetType == bcs.b.c) {
            dy = ((double)((float)(k2 >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.d(dx, dy, dz);
    }
}

