/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.nio.IntBuffer;
import net.optifine.reflect.Reflector;
import net.optifine.shaders.ClippingHelperShadow;
import net.optifine.shaders.Shaders;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class ShadersRender {
    private static final pc END_PORTAL_TEXTURE = new pc("textures/entity/end_portal.png");

    public static void setFrustrumPosition(cwz frustum, double x, double y, double z) {
        frustum.a(x, y, z);
    }

    public static void setupTerrain(cue renderGlobal, aer viewEntity, float partialTicks, cwz camera, int frameCount, boolean playerSpectator) {
        renderGlobal.a(viewEntity, partialTicks, camera, frameCount, playerSpectator);
    }

    public static void beginTerrainSolid() {
        if (Shaders.isRenderingWorld) {
            Shaders.fogEnabled = true;
            Shaders.useProgram(Shaders.ProgramTerrain);
        }
    }

    public static void beginTerrainCutoutMipped() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTerrain);
        }
    }

    public static void beginTerrainCutout() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTerrain);
        }
    }

    public static void endTerrain() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTexturedLit);
        }
    }

    public static void beginTranslucent() {
        if (Shaders.isRenderingWorld) {
            if (Shaders.usedDepthBuffers >= 2) {
                cua.g((int)33995);
                Shaders.checkGLError("pre copy depth");
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)Shaders.renderWidth, (int)Shaders.renderHeight);
                Shaders.checkGLError("copy depth");
                cua.g((int)33984);
            }
            Shaders.useProgram(Shaders.ProgramWater);
        }
    }

    public static void endTranslucent() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTexturedLit);
        }
    }

    public static void renderHand0(cty er, float partialTicks) {
        if (!Shaders.isShadowPass) {
            boolean blockTranslucentMain = Shaders.isItemToRenderMainTranslucent();
            boolean blockTranslucentOff = Shaders.isItemToRenderOffTranslucent();
            if (!blockTranslucentMain || !blockTranslucentOff) {
                Shaders.readCenterDepth();
                Shaders.beginHand(false);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Shaders.setSkipRenderHands(blockTranslucentMain, blockTranslucentOff);
                er.renderHand(partialTicks, true, false, false);
                Shaders.endHand();
                Shaders.setHandsRendered(!blockTranslucentMain, !blockTranslucentOff);
                Shaders.setSkipRenderHands(false, false);
            }
        }
    }

    public static void renderHand1(cty er, float partialTicks) {
        if (!Shaders.isShadowPass && !Shaders.isBothHandsRendered()) {
            Shaders.readCenterDepth();
            cua.m();
            Shaders.beginHand(true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Shaders.setSkipRenderHands(Shaders.isHandRenderedMain(), Shaders.isHandRenderedOff());
            er.renderHand(partialTicks, true, false, true);
            Shaders.endHand();
            Shaders.setHandsRendered(true, true);
            Shaders.setSkipRenderHands(false, false);
        }
    }

    public static void renderItemFP(cuc itemRenderer, float par1, boolean renderTranslucent) {
        Shaders.setRenderingFirstPersonHand(true);
        cua.a((boolean)true);
        if (renderTranslucent) {
            cua.c((int)519);
            GL11.glPushMatrix();
            IntBuffer drawBuffers = Shaders.activeDrawBuffers;
            Shaders.setDrawBuffers(Shaders.drawBuffersNone);
            Shaders.renderItemKeepDepthMask = true;
            itemRenderer.a(par1);
            Shaders.renderItemKeepDepthMask = false;
            Shaders.setDrawBuffers(drawBuffers);
            GL11.glPopMatrix();
        }
        cua.c((int)515);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        itemRenderer.a(par1);
        Shaders.setRenderingFirstPersonHand(false);
    }

    public static void renderFPOverlay(cty er, float partialTicks) {
        if (!Shaders.isShadowPass) {
            Shaders.beginFPOverlay();
            er.renderHand(partialTicks, false, true, false);
            Shaders.endFPOverlay();
        }
    }

    public static void beginBlockDamage() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramDamagedBlock);
            if (Shaders.ProgramDamagedBlock.getId() == Shaders.ProgramTerrain.getId()) {
                Shaders.setDrawBuffers(Shaders.drawBuffersColorAtt0);
                cua.a((boolean)false);
            }
        }
    }

    public static void endBlockDamage() {
        if (Shaders.isRenderingWorld) {
            cua.a((boolean)true);
            Shaders.useProgram(Shaders.ProgramTexturedLit);
        }
    }

    public static void renderShadowMap(cty entityRenderer, int pass, float partialTicks, long finishTimeNano) {
        if (Shaders.usedShadowDepthBuffers > 0 && --Shaders.shadowPassCounter <= 0) {
            cft mc = cft.s();
            mc.y.c("shadow pass");
            cue renderGlobal = mc.h;
            Shaders.isShadowPass = true;
            Shaders.shadowPassCounter = Shaders.shadowPassInterval;
            Shaders.preShadowPassThirdPersonView = mc.t.aA;
            mc.t.aA = 1;
            Shaders.checkGLError("pre shadow");
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            mc.y.c("shadow clear");
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)Shaders.sfb);
            Shaders.checkGLError("shadow bind sfb");
            mc.y.c("shadow camera");
            entityRenderer.h(partialTicks);
            Shaders.setCameraShadow(partialTicks);
            Shaders.checkGLError("shadow camera");
            Shaders.useProgram(Shaders.ProgramShadow);
            GL20.glDrawBuffers((IntBuffer)Shaders.sfbDrawBuffers);
            Shaders.checkGLError("shadow drawbuffers");
            GL11.glReadBuffer((int)0);
            Shaders.checkGLError("shadow readbuffer");
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)Shaders.sfbDepthTextures.get(0), (int)0);
            if (Shaders.usedShadowColorBuffers != 0) {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)Shaders.sfbColorTextures.get(0), (int)0);
            }
            Shaders.checkFramebufferStatus("shadow fb");
            GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glClear((int)(Shaders.usedShadowColorBuffers != 0 ? 16640 : 256));
            Shaders.checkGLError("shadow clear");
            mc.y.c("shadow frustum");
            cxc clippingHelper = ClippingHelperShadow.getInstance();
            mc.y.c("shadow culling");
            cxb frustum = new cxb(clippingHelper);
            aer viewEntity = mc.S();
            double viewPosX = viewEntity.N + (viewEntity.q - viewEntity.N) * (double)partialTicks;
            double viewPosY = viewEntity.O + (viewEntity.r - viewEntity.O) * (double)partialTicks;
            double viewPosZ = viewEntity.P + (viewEntity.s - viewEntity.P) * (double)partialTicks;
            frustum.a(viewPosX, viewPosY, viewPosZ);
            cua.j((int)7425);
            cua.k();
            cua.c((int)515);
            cua.a((boolean)true);
            cua.a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            cua.r();
            mc.y.c("shadow prepareterrain");
            mc.E().a(ddl.f);
            mc.y.c("shadow setupterrain");
            int frameCount = 0;
            frameCount = entityRenderer.P;
            entityRenderer.P = frameCount + 1;
            renderGlobal.a(viewEntity, partialTicks, (cwz)frustum, frameCount, mc.i.t());
            mc.y.c("shadow updatechunks");
            mc.y.c("shadow terrain");
            cua.n((int)5888);
            cua.G();
            cua.d();
            renderGlobal.a(axl.a, (double)partialTicks, viewEntity);
            Shaders.checkGLError("shadow terrain solid");
            cua.e();
            renderGlobal.a(axl.b, (double)partialTicks, viewEntity);
            Shaders.checkGLError("shadow terrain cutoutmipped");
            mc.E().b(ddl.f).b(false, false);
            renderGlobal.a(axl.c, (double)partialTicks, viewEntity);
            Shaders.checkGLError("shadow terrain cutout");
            mc.E().b(ddl.f).b();
            cua.j((int)7424);
            cua.a((int)516, (float)0.1f);
            cua.n((int)5888);
            cua.H();
            cua.G();
            mc.y.c("shadow entities");
            if (Reflector.ForgeHooksClient_setRenderPass.exists()) {
                Reflector.callVoid(Reflector.ForgeHooksClient_setRenderPass, 0);
            }
            renderGlobal.a(viewEntity, (cwz)frustum, partialTicks);
            Shaders.checkGLError("shadow entities");
            cua.n((int)5888);
            cua.H();
            cua.a((boolean)true);
            cua.l();
            cua.q();
            cua.a((int)770, (int)771, (int)1, (int)0);
            cua.a((int)516, (float)0.1f);
            if (Shaders.usedShadowDepthBuffers >= 2) {
                cua.g((int)33989);
                Shaders.checkGLError("pre copy shadow depth");
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)Shaders.shadowMapWidth, (int)Shaders.shadowMapHeight);
                Shaders.checkGLError("copy shadow depth");
                cua.g((int)33984);
            }
            cua.l();
            cua.a((boolean)true);
            mc.E().a(ddl.f);
            cua.j((int)7425);
            Shaders.checkGLError("shadow pre-translucent");
            GL20.glDrawBuffers((IntBuffer)Shaders.sfbDrawBuffers);
            Shaders.checkGLError("shadow drawbuffers pre-translucent");
            Shaders.checkFramebufferStatus("shadow pre-translucent");
            if (Shaders.isRenderShadowTranslucent()) {
                mc.y.c("shadow translucent");
                renderGlobal.a(axl.d, (double)partialTicks, viewEntity);
                Shaders.checkGLError("shadow translucent");
            }
            if (Reflector.ForgeHooksClient_setRenderPass.exists()) {
                cfr.b();
                Reflector.call(Reflector.ForgeHooksClient_setRenderPass, 1);
                renderGlobal.a(viewEntity, (cwz)frustum, partialTicks);
                Reflector.call(Reflector.ForgeHooksClient_setRenderPass, -1);
                cfr.a();
                Shaders.checkGLError("shadow entities 1");
            }
            cua.j((int)7424);
            cua.a((boolean)true);
            cua.q();
            cua.l();
            GL11.glFlush();
            Shaders.checkGLError("shadow flush");
            Shaders.isShadowPass = false;
            mc.t.aA = Shaders.preShadowPassThirdPersonView;
            mc.y.c("shadow postprocess");
            if (Shaders.hasGlGenMipmap) {
                if (Shaders.usedShadowDepthBuffers >= 1) {
                    if (Shaders.shadowMipmapEnabled[0]) {
                        cua.g((int)33988);
                        cua.i((int)Shaders.sfbDepthTextures.get(0));
                        GL30.glGenerateMipmap((int)3553);
                        GL11.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowFilterNearest[0] ? 9984 : 9987));
                    }
                    if (Shaders.usedShadowDepthBuffers >= 2 && Shaders.shadowMipmapEnabled[1]) {
                        cua.g((int)33989);
                        cua.i((int)Shaders.sfbDepthTextures.get(1));
                        GL30.glGenerateMipmap((int)3553);
                        GL11.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowFilterNearest[1] ? 9984 : 9987));
                    }
                    cua.g((int)33984);
                }
                if (Shaders.usedShadowColorBuffers >= 1) {
                    if (Shaders.shadowColorMipmapEnabled[0]) {
                        cua.g((int)33997);
                        cua.i((int)Shaders.sfbColorTextures.get(0));
                        GL30.glGenerateMipmap((int)3553);
                        GL11.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowColorFilterNearest[0] ? 9984 : 9987));
                    }
                    if (Shaders.usedShadowColorBuffers >= 2 && Shaders.shadowColorMipmapEnabled[1]) {
                        cua.g((int)33998);
                        cua.i((int)Shaders.sfbColorTextures.get(1));
                        GL30.glGenerateMipmap((int)3553);
                        GL11.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowColorFilterNearest[1] ? 9984 : 9987));
                    }
                    cua.g((int)33984);
                }
            }
            Shaders.checkGLError("shadow postprocess");
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)Shaders.dfb);
            GL11.glViewport((int)0, (int)0, (int)Shaders.renderWidth, (int)Shaders.renderHeight);
            Shaders.activeDrawBuffers = null;
            mc.E().a(ddl.f);
            Shaders.useProgram(Shaders.ProgramTerrain);
            GL11.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            Shaders.checkGLError("shadow end");
        }
    }

    public static void preRenderChunkLayer(axl blockLayerIn) {
        if (Shaders.isRenderBackFace(blockLayerIn)) {
            cua.r();
        }
        if (dhq.f()) {
            GL11.glEnableClientState((int)32885);
            GL20.glEnableVertexAttribArray((int)Shaders.midTexCoordAttrib);
            GL20.glEnableVertexAttribArray((int)Shaders.tangentAttrib);
            GL20.glEnableVertexAttribArray((int)Shaders.entityAttrib);
        }
    }

    public static void postRenderChunkLayer(axl blockLayerIn) {
        if (dhq.f()) {
            GL11.glDisableClientState((int)32885);
            GL20.glDisableVertexAttribArray((int)Shaders.midTexCoordAttrib);
            GL20.glDisableVertexAttribArray((int)Shaders.tangentAttrib);
            GL20.glDisableVertexAttribArray((int)Shaders.entityAttrib);
        }
        if (Shaders.isRenderBackFace(blockLayerIn)) {
            cua.q();
        }
    }

    public static void setupArrayPointersVbo() {
        int vertexSizeI = 14;
        GL11.glVertexPointer((int)3, (int)5126, (int)56, (long)0L);
        GL11.glColorPointer((int)4, (int)5121, (int)56, (long)12L);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)56, (long)16L);
        dhq.l((int)dhq.r);
        GL11.glTexCoordPointer((int)2, (int)5122, (int)56, (long)24L);
        dhq.l((int)dhq.q);
        GL11.glNormalPointer((int)5120, (int)56, (long)28L);
        GL20.glVertexAttribPointer((int)Shaders.midTexCoordAttrib, (int)2, (int)5126, (boolean)false, (int)56, (long)32L);
        GL20.glVertexAttribPointer((int)Shaders.tangentAttrib, (int)4, (int)5122, (boolean)false, (int)56, (long)40L);
        GL20.glVertexAttribPointer((int)Shaders.entityAttrib, (int)3, (int)5122, (boolean)false, (int)56, (long)48L);
    }

    public static void beaconBeamBegin() {
        Shaders.useProgram(Shaders.ProgramBeaconBeam);
    }

    public static void beaconBeamStartQuad1() {
    }

    public static void beaconBeamStartQuad2() {
    }

    public static void beaconBeamDraw1() {
    }

    public static void beaconBeamDraw2() {
        cua.l();
    }

    public static void renderEnchantedGlintBegin() {
        Shaders.useProgram(Shaders.ProgramArmorGlint);
    }

    public static void renderEnchantedGlintEnd() {
        if (Shaders.isRenderingWorld) {
            if (Shaders.isRenderingFirstPersonHand() && Shaders.isRenderBothHands()) {
                Shaders.useProgram(Shaders.ProgramHand);
            } else {
                Shaders.useProgram(Shaders.ProgramEntities);
            }
        } else {
            Shaders.useProgram(Shaders.ProgramNone);
        }
    }

    public static boolean renderEndPortal(bkh te, double x, double y, double z, float partialTicks, int destroyStage, float offset) {
        int lu;
        float du;
        if (!Shaders.isShadowPass && Shaders.activeProgram.getId() == 0) {
            return false;
        }
        cua.g();
        Config.getTextureManager().a(END_PORTAL_TEXTURE);
        cum tessellator = cum.a();
        ctq bufferbuilder = tessellator.c();
        bufferbuilder.a(7, ddu.g);
        float col = 0.5f;
        float r = col * 0.15f;
        float g = col * 0.3f;
        float b2 = col * 0.4f;
        float u0 = 0.0f;
        float u1 = 0.2f;
        float v0 = u0;
        float v1 = u1;
        float dv = du = (float)(System.currentTimeMillis() % 100000L) / 100000.0f;
        float dy = offset;
        int lv = lu = 240;
        if (te.a(eq.d)) {
            bufferbuilder.b(x, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v0 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y + 1.0, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x, y + 1.0, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v0 + dv)).a(lu, lv).d();
        }
        if (te.a(eq.c)) {
            bufferbuilder.b(x, y + 1.0, z).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y + 1.0, z).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v0 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v0 + dv)).a(lu, lv).d();
            bufferbuilder.b(x, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v1 + dv)).a(lu, lv).d();
        }
        if (te.a(eq.f)) {
            bufferbuilder.b(x + 1.0, y + 1.0, z).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y + 1.0, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v0 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v0 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v1 + dv)).a(lu, lv).d();
        }
        if (te.a(eq.e)) {
            bufferbuilder.b(x, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v0 + dv)).a(lu, lv).d();
            bufferbuilder.b(x, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x, y + 1.0, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x, y + 1.0, z).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v0 + dv)).a(lu, lv).d();
        }
        if (te.a(eq.a)) {
            bufferbuilder.b(x, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v0 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v0 + dv)).a(lu, lv).d();
        }
        if (te.a(eq.b)) {
            bufferbuilder.b(x, y + (double)dy, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v0 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y + (double)dy, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x + 1.0, y + (double)dy, z).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v1 + dv)).a(lu, lv).d();
            bufferbuilder.b(x, y + (double)dy, z).a(r, g, b2, 1.0f).a((double)(u1 + du), (double)(v0 + dv)).a(lu, lv).d();
        }
        tessellator.b();
        cua.f();
        return true;
    }
}

